<?php

namespace App\Console\Commands;

use Exception;
use Illuminate\Console\Command;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Log;
use Spatie\DbDumper\Compressors\GzipCompressor;
use Spatie\DbDumper\Databases\MySql as MysqlDumper;

class BackupDatabase extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'app:backupdatabase';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Creates a backup of the database';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        if (strtoupper(substr(PHP_OS, 0, 3)) === 'WIN') {
            $this->error('DB Backup script is only working under linux !!!');

            return 1;
        }
        $start_ts = Carbon::now();

        try {
            $databaseName = config('database.connections.mysql.database');
            $userName = config('database.connections.mysql.username');
            $password = config('database.connections.mysql.password');
            $port = config('database.connections.mysql.port');
            $host = config('database.connections.mysql.host');
            $backup_file = config('database.connections.mysql.backup_path').DIRECTORY_SEPARATOR.date('Ymd_His').'_db_backup.sql.gz';

            MysqlDumper::create()
                ->setHost($host)
                ->setPort($port)
                ->setDbName($databaseName)
                ->setUserName($userName)
                ->setPassword($password)
                ->useCompressor(new GzipCompressor)
                ->dumpToFile($backup_file);

            $runtime_sec = $start_ts->diffInSeconds(Carbon::now(), true);
            $msg = 'DB backup created in '.$backup_file.' with '.number_format(filesize($backup_file), 0, '', '.').' byte in '.$runtime_sec.' sec';
            $this->info($msg);
            Log::channel('admin')->info('BackupDatabase '.$msg);

            return 0;
        } catch (Exception $e) {
            // throw $th;
            $msg = 'Error on creating db backup: '.$e->getMessage();
            $this->error($msg);
            Log::channel('admin')->error('BackupDatabase '.$msg);

            return 1;
        }
    }
}
