<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Process;
use Illuminate\Support\Number;

class BackupPictures extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'app:backup-pictures';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Make backup for all pictures from storage dir';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $start_ts = Carbon::now();
        $folderPath = public_path('storage');
        $zipPath = config('database.connections.mysql.backup_path').DIRECTORY_SEPARATOR.date('Ymd_His').'_picture_backup.zip';

        $result = Process::path($folderPath)->run("zip -rq $zipPath .");

        if ($result->failed()) {
            $msg = 'Error during picture backup.'."\n".$result->errorOutput();
            $this->error($msg);
            Log::channel('admin')->error('BackupPictures '.$msg);

            return self::FAILURE;
        }

        $runtime_sec = $start_ts->diffInSeconds(Carbon::now(), true);
        $msg = 'Picture backup created in '.$zipPath.' with '.Number::fileSize(filesize($zipPath)).' in '.$runtime_sec.' sec';
        $this->info($msg);
        Log::channel('admin')->info('BackupPictures '.$msg);

        return self::SUCCESS;
    }
}
