<?php

namespace App\Console\Commands;

use App\Models\Post;
use Illuminate\Console\Command;
use Spatie\Sitemap\Sitemap;
use Spatie\Sitemap\SitemapGenerator;
use Spatie\Sitemap\Tags\Url;

class CreateSitemap extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'app:sitemap';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Refresh sitemap file';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $path = public_path('sitemap.xml');
        $url = config('app.url');
        $this->info('Crawling url '.$url.' ...');

        // SitemapGenerator::create($url)->writeToFile($path);

        Sitemap::create()
            ->add(Url::create('/')->setLastModificationDate(Post::where('slug', 'home')->first()->updated_at))
            ->add(Url::create('/home')->setLastModificationDate(Post::where('slug', 'home')->first()->updated_at))
            ->add(Url::create('/market')->setLastModificationDate(Post::where('slug', 'market')->first()->updated_at))
            ->add(Url::create('/prerecording')->setLastModificationDate(Post::where('slug', 'prerecording')->first()->updated_at))
            ->add(Url::create('/contact_legal')->setLastModificationDate(Post::where('slug', 'contact_legal')->first()->updated_at))
            ->add('/admin/login')
            ->add('/admin/register')
            ->add('/admin/password-reset/request')
            ->writeToFile($path);

        $this->info('Sitemap '.$path.' generated.');
    }
}
