<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;

class DecryptConfig extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'app:decryptconfig {stage}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Decrypts config for different stages, for example production = .env.production and playground = .env.playground';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $stage = trim($this->argument('stage'));

        $key = getenv('APP_ENV_CRYPTO_KEY_TAUSCHMARKT');
        if (strlen($key) > 10 && ($stage == 'production' || $stage == 'playground' || $stage == 'local')) {

            // make bakup file if its stage local
            if ($stage == 'local' && file_exists(base_path('.env'))) {
                copy(base_path('.env'), base_path('.env').'_backup_'.date('Ymd_His'));
            }

            if ($stage == 'local') {
                $this->call('env:decrypt', [
                    '--key' => $key,
                    '--force' => true,
                ]);
            } else {
                $this->call('env:decrypt', [
                    '--env' => $stage,
                    '--key' => $key,
                    '--force' => true,
                ]);
            }
            $this->info('Done.');

            return Command::SUCCESS;
        } else {
            $this->error('Key in APP_ENV_CRYPTO_KEY_TAUSCHMARKT in .env file not set or stage='.$stage.' not valid');

            return Command::FAILURE;
        }
    }
}
