<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;

class EncryptConfig extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'app:encryptconfig';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Creates an encrypted config files which can be stored in git repo';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        if (! $this->confirm('Are you sure that the current encrypted files are the newest ones? If not checkout repo to another folder and decrypt the latest files and compare!', false)) {
            $this->warn('Encryption cancelled.');

            return Command::SUCCESS;
        }

        $key = getenv('APP_ENV_CRYPTO_KEY_TAUSCHMARKT');
        if (strlen($key) > 10) {

            $this->call('env:encrypt', [
                '--env' => 'production',
                '--key' => $key,
                '--force' => true,
            ]);

            $this->call('env:encrypt', [
                '--env' => 'playground',
                '--key' => $key,
                '--force' => true,
            ]);

            $this->call('env:encrypt', [
                '--key' => $key,
                '--force' => true,
            ]);

            $this->info('Done.');

            return Command::SUCCESS;
        } else {
            $this->error('Key in APP_ENV_CRYPTO_KEY_TAUSCHMARKT in .env file not set');

            return Command::FAILURE;
        }
    }
}
