<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Str;

class Version extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'app:version {version=not-set} {--short}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Shows current app version or sets it if parameter passed';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        // show version
        $input_version = trim($this->argument('version'));
        if ($input_version === 'not-set') {
            $version = config('app.version');
            if ($this->option('short')) {
                $this->info($version);
            } else {
                $this->info('Current app version is: '.$version);
            }

            return self::SUCCESS;
        } else {
            // set version
            $new_version = $input_version;
            $old_version = config('app.version');

            // change config/app.php
            $app_version_file = base_path('config/app.php');
            $file_old = File::get($app_version_file);
            $string_old = Str::between($file_old, 'autochange-start', 'autochange-end');
            $string_new = str_replace($old_version, $new_version, $string_old);
            $file_new = str_replace($string_old, $string_new, $file_old);
            File::put($app_version_file, $file_new);

            $this->info('Version changed from '.$old_version.' to '.$new_version);

            return self::SUCCESS;
        }
    }
}
