<?php

namespace App\Filament\Guest\Pages;

use App\Models\Post;
use BackedEnum;
use Filament\Pages\Page;

class Market extends Page
{
    protected string $view = 'filament.default.page';

    public string $page_slug = 'market';

    protected static BackedEnum|string|null $navigationIcon = 'heroicon-o-information-circle';

    // protected static string|\UnitEnum|null $navigationGroup = 'Admin';

    protected static ?int $navigationSort = 20;

    public function getTitle(): string
    {
        return Post::where('slug', $this->page_slug)->select('title')->first()?->title ?? 'Error: Title not found';
    }

    public static function getNavigationLabel(): string
    {
        return Post::where('slug', 'market')->select('title')->first()?->title ?? 'Error: Title not found';
    }
}
