<?php

namespace App\Filament\Guest\Pages;

use App\Models\Post;
use BackedEnum;
use Filament\Pages\Page;

class Prerecording extends Page
{
    protected string $view = 'filament.default.page';

    public string $page_slug = 'prerecording';

    protected static BackedEnum|string|null $navigationIcon = 'heroicon-o-building-storefront';

    // protected static string|\UnitEnum|null $navigationGroup = 'Admin';

    protected static ?int $navigationSort = 30;

    public function getTitle(): string
    {
        return Post::where('slug', $this->page_slug)->select('title')->first()?->title ?? 'Error: Title not found';
    }

    public static function getNavigationLabel(): string
    {
        return Post::where('slug', 'prerecording')->select('title')->first()?->title ?? 'Error: Title not found';
    }
}
