<?php

namespace App\Filament\Pages\Auth;

use Filament\Auth\Pages\Login as BaseLogin;
use Filament\Infolists\Components\TextEntry;
use Filament\Schemas\Schema;
use Filament\Support\Enums\TextSize;
use Filament\Support\Icons\Heroicon;
use Illuminate\Support\Facades\App;

class CustomLogin extends BaseLogin
{
    public function form(Schema $schema): Schema
    {
        return $schema
            ->components([
                TextEntry::make('warning_playground')
                    ->visible(App::environment('playground'))
                    // ->color('error')
                    ->color('danger')
                    ->icon(Heroicon::ExclamationTriangle)
                    ->iconColor('danger')
                    ->hiddenLabel()
                    // ->badge()
                    ->size(TextSize::Large)
                    ->state('Du befindest dich am Playground/Spielplatz, alle eingegebenen Daten werden laufend gelöscht. Die Webseite dient nur zum Testen und ausprobieren'),
                $this->getEmailFormComponent(),
                $this->getPasswordFormComponent(),
                $this->getRememberFormComponent(),
            ]);
    }
}
