<?php

namespace App\Filament\Pages\Auth;

use BackedEnum;
use Filament\Pages\Page;
use Illuminate\Support\Facades\Auth;

/**
 * We use a "logput" page here as workaround in order to get a logout button visible on the main filament menue
 * Login Button including logic is defined in app/Providers/Filament/GuestPanelProvider.php
 */
class CustomLogout extends Page
{
    protected static BackedEnum|string|null $navigationIcon = 'heroicon-o-arrow-left-on-rectangle';

    protected static ?int $navigationSort = 90;

    protected static ?string $navigationLabel = 'Logout';

    public function mount(): void
    {
        Auth::logout();
        session()->invalidate();
        session()->regenerateToken();

        redirect(url('/'));
    }

    public static function canAccess(): bool
    {
        return true;
    }

    public static function shouldRegisterNavigation(): bool
    {
        return Auth::check();
    }
}
