<?php

namespace App\Filament\Pages;

use App\Models\Post;
use BackedEnum;
use Filament\Pages\Page;
use Illuminate\Support\Facades\Auth;

class ChecklistKitchen extends Page
{
    protected string $view = 'filament.default.page';

    public string $page_slug = 'checklist_kitchen';

    protected static BackedEnum|string|null $navigationIcon = 'heroicon-o-cake';

    protected static string|\UnitEnum|null $navigationGroup = 'Checklisten';

    protected static ?int $navigationSort = 30;

    public function getTitle(): string
    {
        return Post::where('slug', $this->page_slug)->select('title')->first()?->title ?? 'Error: Title not found';
    }

    public static function getNavigationLabel(): string
    {
        return Post::where('slug', 'checklist_kitchen')->select('title')->first()?->title ?? 'Error: Title not found';
    }

    public static function canAccess(): bool
    {
        /** @var User */
        $user = Auth::user();

        return $user->hasAnyRole(['admin', 'super_admin']);
    }
}
