<?php

namespace App\Filament\Pages;

use App\Models\Post;
use BackedEnum;
use Filament\Pages\Page;
use Illuminate\Support\Facades\Auth;

class ChecklistTechsetup extends Page
{
    protected string $view = 'filament.default.page';

    public string $page_slug = 'checklist_techsetup';

    protected static BackedEnum|string|null $navigationIcon = 'heroicon-o-command-line';

    protected static string|\UnitEnum|null $navigationGroup = 'Checklisten';

    protected static ?int $navigationSort = 40;

    public function getTitle(): string
    {
        return Post::where('slug', $this->page_slug)->select('title')->first()?->title ?? 'Error: Title not found';
    }

    public static function getNavigationLabel(): string
    {
        return Post::where('slug', 'checklist_techsetup')->select('title')->first()?->title ?? 'Error: Title not found';
    }

    public static function canAccess(): bool
    {
        /** @var User */
        $user = Auth::user();

        return $user->hasAnyRole(['admin', 'super_admin']);
    }
}
