<?php

namespace App\Filament\Pages;

use Filament\Pages\Page;
use Illuminate\Support\Facades\Auth;

class SystemInfos extends Page
{
    protected string $view = 'filament.pages.system-infos';

    protected static string|\BackedEnum|null $navigationIcon = 'heroicon-o-information-circle';

    protected static string|\UnitEnum|null $navigationGroup = 'Super Admin';

    protected static ?int $navigationSort = 120;

    public static function canAccess(): bool
    {
        /** @var User */
        $user = Auth::user();

        return $user->hasRole('super_admin'); // we need to manually check here for super admin role as somehow its not working via policy (maybe a special case)
    }
}
