<?php

namespace App\Filament\Resources\AllArticles;

use App\Filament\Resources\AllArticles\Pages\ListAllArticles;
use App\Filament\Resources\AllArticles\Pages\ViewAllArticle;
use App\Filament\Resources\AllArticles\Schemas\AllArticleForm;
use App\Filament\Resources\AllArticles\Schemas\AllArticleInfolist;
use App\Filament\Resources\AllArticles\Tables\AllArticlesTable;
use App\Models\AllArticle;
use BackedEnum;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;

class AllArticleResource extends Resource
{
    protected static ?string $model = AllArticle::class;

    protected static string|BackedEnum|null $navigationIcon = Heroicon::NumberedList;

    protected static string|\UnitEnum|null $navigationGroup = 'Admin';

    protected static ?int $navigationSort = 110;

    protected static ?string $modelLabel = 'Artikel Liste Alle';

    protected static ?string $pluralModelLabel = 'Artikel Liste Alle';

    protected static ?string $recordTitleAttribute = 'name';

    protected static bool $isGloballySearchable = false;

    public static function form(Schema $schema): Schema
    {
        return AllArticleForm::configure($schema);
    }

    public static function infolist(Schema $schema): Schema
    {
        return AllArticleInfolist::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return AllArticlesTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListAllArticles::route('/'),
            'view' => ViewAllArticle::route('/{record}'),
        ];
    }

    public static function getNavigationBadge(): ?string
    {
        return (string) static::getModel()::count();
    }
}
