<?php

namespace App\Filament\Resources\AllArticles\Schemas;

use Filament\Forms\Components\TextInput;
use Filament\Schemas\Schema;

class AllArticleForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                TextInput::make('id')
                    ->required()
                    ->numeric(),
                TextInput::make('user_id')
                    ->required()
                    ->numeric(),
                TextInput::make('ean'),
                TextInput::make('name')
                    ->required(),
                TextInput::make('price')
                    ->required()
                    ->numeric()
                    ->prefix('$'),
                TextInput::make('article_group_id')
                    ->numeric(),
                TextInput::make('size'),
                TextInput::make('brand'),
                TextInput::make('imported_year')
                    ->numeric(),
                TextInput::make('lables_needed')
                    ->required()
                    ->numeric()
                    ->default(1),
            ]);
    }
}
