<?php

namespace App\Filament\Resources\AllArticles\Schemas;

use Filament\Infolists\Components\TextEntry;
use Filament\Schemas\Schema;

class AllArticleInfolist
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                TextEntry::make('id')
                    ->numeric(),
                TextEntry::make('user_id')
                    ->numeric(),
                TextEntry::make('user.name')
                    ->label('User Name'),
                TextEntry::make('ean')
                    ->placeholder('-'),
                TextEntry::make('name'),
                TextEntry::make('price')
                    ->money('euro'),
                TextEntry::make('article_group_id')
                    ->numeric()
                    ->placeholder('-'),
                TextEntry::make('articleGroup.name'),
                TextEntry::make('size')
                    ->placeholder('-'),
                TextEntry::make('brand')
                    ->placeholder('-'),
                TextEntry::make('imported_year')
                    ->numeric()
                    ->placeholder('-'),
                TextEntry::make('lables_needed')
                    ->numeric(),
                TextEntry::make('created_at')
                    ->dateTime()
                    ->placeholder('-'),
                TextEntry::make('updated_at')
                    ->dateTime()
                    ->placeholder('-'),
            ]);
    }
}
