<?php

namespace App\Filament\Resources\AllArticles\Tables;

use App\Models\ArticleGroup;
use App\Models\User;
use Filament\Actions\ViewAction;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Filters\SelectFilter;
use Filament\Tables\Table;

class AllArticlesTable
{
    public static function configure(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('id')
                    ->label('ArtikelNr')
                    ->numeric()
                    ->sortable(),
                TextColumn::make('user_id')
                    ->label('User Id')
                    ->numeric()
                    ->sortable(),
                TextColumn::make('user.name')
                    ->label('User Name')
                    ->searchable()
                    ->toggleable(isToggledHiddenByDefault: true),
                TextColumn::make('ean')
                    ->searchable()
                    ->toggleable(isToggledHiddenByDefault: true),
                TextColumn::make('name')
                    ->wrap()
                    ->searchable(),
                TextColumn::make('price')
                    ->money('euro')
                    ->sortable(),
                TextColumn::make('articleGroup.name'),
                TextColumn::make('article_group_id')
                    ->numeric()
                    ->toggleable(isToggledHiddenByDefault: true)
                    ->sortable(),
                TextColumn::make('size')
                    ->sortable()
                    ->searchable(),
                TextColumn::make('brand')
                    ->searchable(),
                TextColumn::make('imported_year')
                    ->toggleable(isToggledHiddenByDefault: true)
                    ->numeric()
                    ->sortable(),
                TextColumn::make('lables_needed')
                    ->label('Etiketten')
                    ->numeric()
                    ->sortable(),
                TextColumn::make('created_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                TextColumn::make('updated_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                SelectFilter::make('user_id')
                    ->multiple()
                    ->options(User::all()->whereNotNull('name')->pluck('name', 'id'))
                    ->preload(),
                SelectFilter::make('article_group_id')
                    ->multiple()
                    ->options(ArticleGroup::all()->whereNotNull('name')->pluck('name', 'id'))
                    ->preload(),
            ])
            ->recordActions([
                ViewAction::make(),
            ])
            ->toolbarActions([
            ])
            ->paginationPageOptions([10, 50, 100, 250]);
    }
}
