<?php

namespace App\Filament\Resources\ArticleGroups;

use App\Filament\Resources\ArticleGroups\Pages\EditArticleGroup;
use App\Filament\Resources\ArticleGroups\Pages\ListArticleGroups;
use App\Filament\Resources\ArticleGroups\Schemas\ArticleGroupForm;
use App\Filament\Resources\ArticleGroups\Schemas\ArticleGroupInfolist;
use App\Filament\Resources\ArticleGroups\Tables\ArticleGroupsTable;
use App\Models\ArticleGroup;
use BackedEnum;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;

class ArticleGroupResource extends Resource
{
    protected static ?string $model = ArticleGroup::class;

    protected static string|BackedEnum|null $navigationIcon = Heroicon::OutlinedTag;

    protected static ?string $recordTitleAttribute = 'name';

    protected static string|\UnitEnum|null $navigationGroup = 'Admin';

    protected static ?int $navigationSort = 200;

    protected static bool $isGloballySearchable = false;

    public static function form(Schema $schema): Schema
    {
        return ArticleGroupForm::configure($schema);
    }

    public static function infolist(Schema $schema): Schema
    {
        return ArticleGroupInfolist::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return ArticleGroupsTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListArticleGroups::route('/'),
            'edit' => EditArticleGroup::route('/{record}/edit'),
        ];
    }

    public static function getNavigationBadge(): ?string
    {
        return (string) static::getModel()::count();
    }
}
