<?php

namespace App\Filament\Resources\ArticleGroups\Schemas;

use Filament\Forms\Components\TextInput;
use Filament\Schemas\Schema;

class ArticleGroupForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                TextInput::make('id')
                    ->disabled()
                    ->required(),
                TextInput::make('name')
                    ->disabled()
                    ->required(),
                TextInput::make('price_limit')
                    ->minValue(50)
                    ->maxValue(99999)
                    ->required()
                    ->numeric(),
            ]);
    }
}
