<?php

namespace App\Filament\Resources\Articles\Pages;

use App\Filament\Resources\Articles\ArticleResource;
use App\Models\Article;
use App\Models\Setting;
use Filament\Notifications\Notification;
use Filament\Resources\Pages\CreateRecord;
use Illuminate\Support\Facades\DB;

class CreateArticle extends CreateRecord
{
    protected static string $resource = ArticleResource::class;

    protected function beforeCreate(): void
    {
        // enforce max articles per customer limit
        $max_customer = Setting::getMaxArticlesPerCustomer();
        if (Article::count() >= $max_customer) {
            Notification::make()
                ->title('Maximal Artikelanzahl erreicht')
                ->body('Die maximale Artikelanzahl pro Kunde wurde mit '.$max_customer.' Stück erreicht.')
                ->danger()->send();
            $this->halt();
        }

        // enforce max articles total limit
        $max_total = Setting::getMaxArticlesTotal();
        if (DB::table('articles')->count() >= $max_total) {
            Notification::make()
                ->title('Maximal Artikelanzahl erreicht')
                ->body('Die maximale Artikelanzahl in der Vorerfassung wurde mit '.$max_total.' Stück erreicht.')
                ->danger()->send();
            $this->halt();
        }
    }

    protected function getRedirectUrl(): string
    {
        // after create/edit return to table
        return $this->getResource()::getUrl('index');
    }
}
