<?php

namespace App\Filament\Resources\Articles\Pages;

use App\Filament\Resources\Articles\ArticleResource;
use App\Models\Setting;
use Filament\Actions\DeleteAction;
use Filament\Actions\ViewAction;
use Filament\Resources\Pages\EditRecord;

class EditArticle extends EditRecord
{
    protected static string $resource = ArticleResource::class;

    protected function getHeaderActions(): array
    {
        return [
            // ViewAction::make(),
            DeleteAction::make()
                ->hidden(Setting::getPreRecordingDisabled()),
        ];
    }

    protected function getRedirectUrl(): string
    {
        // after create/edit return to table
        return $this->getResource()::getUrl('index');
    }
}
