<?php

namespace App\Filament\Resources\Articles\Pages;

use App\Filament\Resources\Articles\ArticleResource;
use App\Models\Setting;
use Filament\Actions\Action;
use Filament\Actions\CreateAction;
use Filament\Resources\Pages\ListRecords;

class ListArticles extends ListRecords
{
    protected static string $resource = ArticleResource::class;

    protected function getHeaderActions(): array
    {
        return [
            CreateAction::make()->hidden(Setting::getPreRecordingDisabled()),
            Action::make('print')
                ->label('Drucken')
                ->icon('heroicon-o-printer')
                ->url(fn (): string => route('pdf.print'))
                ->color('success')
                ->openUrlInNewTab(),
        ];
    }
}
