<?php

namespace App\Filament\Resources\Articles\Tables;

use App\Models\Setting;
use Filament\Actions\BulkActionGroup;
use Filament\Actions\DeleteBulkAction;
use Filament\Actions\EditAction;
use Filament\Actions\ViewAction;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Table;
use Illuminate\Support\HtmlString;

class ArticlesTable
{
    public static function configure(Table $table): Table
    {
        return $table
            ->emptyStateHeading('Keine Artikel erfasst')
            ->description(function () {
                if (Setting::getPreRecordingDisabled()) {
                    return new HtmlString('
                    <span class="text-warning-600 font-medium">
                        ⚠️ Achtung: Die Vorerfassung ist bereits geschlossen, es können keine weiteren Artikel mehr vorerfasst werden.
                    </span>
                ');
                } else {
                    return null;
                }
            })
            ->columns([
                TextColumn::make('id')
                    ->label('Artikel Nr')
                    ->numeric(decimalPlaces: 0, thousandsSeparator: '')
                    ->searchable()
                    ->sortable(),

                TextColumn::make('name')
                    ->label('Artikel Name')
                    ->searchable(),
                TextColumn::make('price')
                    ->label('Preis')
                    ->money('euro')
                    ->sortable(),
                TextColumn::make('articleGroup.name')
                    ->label('Artikel Gruppe')
                    ->sortable(),
                TextColumn::make('size')
                    ->label('Größe')
                    ->searchable(),
                TextColumn::make('brand')
                    ->label('Marke')
                    ->searchable(),
                TextColumn::make('lables_needed')
                    ->label('Etiketten Anzahl')
                    ->numeric()
                    ->sortable(),
                TextColumn::make('created_at')
                    ->label('Erstellung')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                TextColumn::make('updated_at')
                    ->label('Aktualisierung')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                TextColumn::make('ean')
                    ->label('Barcode Inhalt')
                    ->toggleable(isToggledHiddenByDefault: true)
                    ->searchable(),
                TextColumn::make('user_id')
                    ->label('Kunden Nr')
                    ->numeric()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                //
            ])
            ->recordActions([
                ViewAction::make()
                    ->hidden(Setting::getPreRecordingEnabled()),
                EditAction::make()
                    ->hidden(Setting::getPreRecordingDisabled()),
            ])
            ->toolbarActions([
                /*BulkActionGroup::make([
                                    DeleteBulkAction::make()->hidden(Setting::getPreRecordingDisabled()),
                                ]),*/
            ]);
    }
}
