<?php

namespace App\Filament\Resources\Audits\Tables;

use App\Models\Audit;
use App\Models\User;
use Filament\Actions\BulkActionGroup;
use Filament\Actions\DeleteBulkAction;
use Filament\Actions\EditAction;
use Filament\Actions\ViewAction;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Filters\SelectFilter;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;

class AuditsTable
{
    public static function configure(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('id')
                    ->label('Audit-Id')
                    ->toggleable(isToggledHiddenByDefault: true),
                TextColumn::make('user_id')
                    ->searchable(),
                TextColumn::make('user.name')
                    ->toggleable(isToggledHiddenByDefault: true)
                    ->searchable(),
                TextColumn::make('event')
                    ->searchable(),
                TextColumn::make('auditable_type')
                    ->label('Typ')
                    ->formatStateUsing(fn (string $state): string => str_replace('App\\Models\\', '', $state))
                    ->searchable(),
                TextColumn::make('auditable_id')
                    ->label('Model-Id')
                    ->numeric()
                    ->sortable(),
                TextColumn::make('old_values')
                    ->toggleable(isToggledHiddenByDefault: true)
                    ->wrap()
                    ->size('xs')
                    ->limit(100),
                TextColumn::make('new_values')
                    ->toggleable(isToggledHiddenByDefault: true)
                    ->wrap()
                    ->size('xs')
                    ->limit(100),
                TextColumn::make('value_comparison')
                    ->limit(100)
                    ->listWithLineBreaks(),
                TextColumn::make('ip_address')
                    ->searchable()
                    ->toggleable(isToggledHiddenByDefault: true),
                TextColumn::make('user_agent')
                    ->searchable()
                    ->toggleable(isToggledHiddenByDefault: true),
                TextColumn::make('tags')
                    ->searchable()
                    ->toggleable(isToggledHiddenByDefault: true),
                TextColumn::make('created_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                TextColumn::make('updated_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                SelectFilter::make('event')
                    ->options(Audit::getSelectEvent())
                    ->multiple()
                    ->attribute('event'),
                SelectFilter::make('auditable_type')
                    ->options(Audit::getSelectAuditTypes())
                    ->multiple()
                    ->query(function (Builder $query, array $data): Builder {
                        $values = $data['values'] ?? [];
                        if (! empty($values)) {
                            return $query->whereIn('auditable_type', $values);
                        } else {
                            return $query;
                        }
                    }),
                SelectFilter::make('user_id')
                    ->multiple()
                    ->options(User::all()->whereNotNull('name')->pluck('name', 'id'))
                    ->preload(),
            ])
            ->recordActions([
                ViewAction::make(),
                // EditAction::make(),
            ])
            ->toolbarActions([
                /*BulkActionGroup::make([
                    DeleteBulkAction::make(),
                ]),*/
            ]);
    }
}
