<?php

namespace App\Filament\Resources\Files\Schemas;

use Filament\Forms\Components\FileUpload;
use Filament\Forms\Components\TextInput;
use Filament\Schemas\Schema;

class FileForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                TextInput::make('name')
                    ->label('Dateiname/Beschreibung')
                    ->columnSpanFull()
                    ->required(),
                FileUpload::make('file')
                    ->label('Datei')
                    ->columnSpanFull()
                    ->disk('public')
                    ->maxSize(1024 * 5) // 5mb
                    ->visibility('public')
                    ->deletable(false)
                    ->required(),
            ]);
    }
}
