<?php

namespace App\Filament\Resources\Posts\Schemas;

use Filament\Forms\Components\RichEditor;
use Filament\Forms\Components\TextInput;
use Filament\Schemas\Schema;

class PostForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                TextInput::make('title')
                    ->minLength(3)
                    ->maxLength(200)
                    ->required(),
                TextInput::make('slug')
                    ->disabledOn('edit')
                    ->minLength(3)
                    ->maxLength(100)
                    ->required(),
                RichEditor::make('content')
                    ->hint('Bilder nur PNG und JPEG unter 350kb')
                    ->required()
                    ->toolbarButtons([
                        ['bold', 'italic', 'underline', 'link'],
                        ['h1', 'h2', 'h3', 'alignStart', 'alignCenter', 'alignEnd'],
                        ['bulletList', 'orderedList'],
                        ['table', 'attachFiles'],
                        ['undo', 'redo'],
                    ])
                    ->json()
                    ->columnSpanFull()
                    ->fileAttachmentsAcceptedFileTypes(['image/png', 'image/jpeg'])
                    ->fileAttachmentsMaxSize(350)
                    ->fileAttachmentsDisk('public')
                    ->fileAttachmentsVisibility('public')
                    ->minLength(3)
                    ->maxLength(15000)
                    ->resizableImages(),

            ]);
    }
}
