<?php

namespace App\Filament\Resources\Settings\Schemas;

use App\Models\Setting;
use Filament\Forms\Components\DateTimePicker;
use Filament\Forms\Components\RichEditor;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Schemas\Components\Utilities\Get;
use Filament\Schemas\Schema;

class SettingForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                Select::make('type')
                    ->disabledOn('edit')
                    ->options(Setting::selectTypes())
                    ->required(),
                TextInput::make('key')
                    ->disabledOn('edit')
                    ->required(),
                TextInput::make('description')
                    ->disabledOn('edit'),
                TextInput::make('value_numeric')
                    ->numeric()
                    ->maxLength(100)
                    ->visible(fn (Get $get) => $get('type') === 'number')
                    ->formatStateUsing(function ($state, $record) { // workarounds needed as filament needs a uniqe field id to work
                        return intval($record?->value);
                    })
                    ->dehydrateStateUsing(function ($state, $record) {
                        $record->value = $state;

                        return null;
                    }),
                DateTimePicker::make('value')
                    ->format('d.m.Y H:i:s')
                    ->displayFormat('d.m.Y H:i:s')
                    ->visible(fn (Get $get) => $get('type') === 'datetime'),
                RichEditor::make('value_string')
                    ->columnSpanFull()
                    ->maxLength(10000)
                    ->toolbarButtons([
                        ['bold', 'link', 'h1', 'h2', 'h3', 'bulletList', 'orderedList', 'undo', 'redo'],
                    ])
                    ->formatStateUsing(function ($state, $record, $get) { // workarounds needed as filament needs a uniqe field id to work
                        if ($get('type') === 'string' && ! empty($record?->value)) {
                            return $record?->value;
                        } else {
                            return '<p></p>';
                        }
                    })
                    ->dehydrateStateUsing(function ($state, $record) {
                        if (filled($state)) {
                            $record->value = $state;
                        }

                        return null;
                    })
                    ->visible(fn (Get $get) => $get('type') === 'string'),

            ]);
    }
}
