<?php

namespace App\Filament\Resources\TmkArticles\Pages;

use App\Filament\Resources\TmkArticles\TmkArticleResource;
use App\Models\Setting;
use Filament\Notifications\Notification;
use Filament\Resources\Pages\CreateRecord;
use Illuminate\Support\Facades\DB;

class CreateTmkArticle extends CreateRecord
{
    protected static string $resource = TmkArticleResource::class;

    protected function beforeCreate(): void
    {
        // enforce max articles per customer limit -> not donw on tmk articles

        // enforce max articles total limit
        $max_total = Setting::getMaxArticlesTotal();
        if (DB::table('articles')->count() >= $max_total) {
            Notification::make()
                ->title('Maximal Artikelanzahl erreicht')
                ->body('Die maximale Artikelanzahl in der Vorerfassung wurde mit '.$max_total.' Stück erreicht.')
                ->danger()->send();
            $this->halt();
        }
    }

    protected function getRedirectUrl(): string
    {
        // after create/edit return to table
        return $this->getResource()::getUrl('index');
    }
}
