<?php

namespace App\Filament\Resources\TmkArticles\Pages;

use App\Filament\Resources\TmkArticles\TmkArticleResource;
use App\Models\Setting;
use Filament\Actions\DeleteAction;
use Filament\Actions\ViewAction;
use Filament\Resources\Pages\EditRecord;

class EditTmkArticle extends EditRecord
{
    protected static string $resource = TmkArticleResource::class;

    protected function getHeaderActions(): array
    {
        return [
            ViewAction::make(),
            DeleteAction::make()->hidden(Setting::getPreRecordingDisabled()),
        ];
    }

    protected function getRedirectUrl(): string
    {
        // after create/edit return to table
        return $this->getResource()::getUrl('index');
    }
}
