<?php

namespace App\Filament\Resources\TmkArticles;

use App\Filament\Resources\Articles\Schemas\ArticleForm;
use App\Filament\Resources\Articles\Schemas\ArticleInfolist;
use App\Filament\Resources\Articles\Tables\ArticlesTable;
use App\Filament\Resources\TmkArticles\Pages\CreateTmkArticle;
use App\Filament\Resources\TmkArticles\Pages\EditTmkArticle;
use App\Filament\Resources\TmkArticles\Pages\ListTmkArticles;
use App\Filament\Resources\TmkArticles\Pages\ViewTmkArticle;
use App\Models\TmkArticle;
use BackedEnum;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;
use Illuminate\Contracts\Support\Htmlable;
use Illuminate\Database\Eloquent\Model;

class TmkArticleResource extends Resource
{
    protected static ?string $model = TmkArticle::class;

    protected static string|BackedEnum|null $navigationIcon = Heroicon::ShoppingCart;

    protected static ?string $recordTitleAttribute = 'name';

    protected static ?string $modelLabel = 'TMK-Artikel Erfassung';

    protected static ?string $pluralModelLabel = 'TMK-Artikel Erfassung';

    protected static string|\UnitEnum|null $navigationGroup = 'Admin';

    protected static ?int $navigationSort = 5;

    protected static bool $isGloballySearchable = false;

    public static function form(Schema $schema): Schema
    {
        // we share the same logic as article here !!
        return ArticleForm::configure($schema);
    }

    public static function infolist(Schema $schema): Schema
    {
        // we share the same logic as article here !!
        return ArticleInfolist::configure($schema);
    }

    public static function table(Table $table): Table
    {
        // we share the same logic as article here !!
        return ArticlesTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListTmkArticles::route('/'),
            'create' => CreateTmkArticle::route('/create'),
            'view' => ViewTmkArticle::route('/{record}'),
            'edit' => EditTmkArticle::route('/{record}/edit'),
        ];
    }

    public static function getNavigationBadge(): ?string
    {
        return (string) static::getModel()::count();
    }

    public static function getRecordTitle(?Model $record): string|Htmlable|null
    {
        return $record->id.': '.$record->name;
    }
}
