<?php

namespace App\Filament\Resources\Users\Schemas;

use App\Models\User;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Schemas\Schema;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Support\Facades\Auth;

class UserForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                TextInput::make('name')
                    ->disabled()
                    ->required(),
                TextInput::make('email')
                    ->disabled()
                    ->label('Email address')
                    ->email()
                    ->required(),
                TextInput::make('phone')
                    ->disabled(),
                Select::make('roles')
                    ->multiple()
                    ->relationship('roles', 'name', function (Builder $query) {
                        /** @var User|null $user */
                        $user = Auth::user();
                        if (! empty($user) && $user->hasRole('super_admin')) {
                            // superadmins are allowed to add user and admin roles
                            return $query->whereIn('roles.name', ['user', 'admin']);
                        } else {
                            // no roles for everybody else
                            return $query->whereIn('roles.name', []);
                        }
                    })
                    ->preload(),
            ]);
    }
}
