<?php

namespace App\Filament\Resources\Users\Tables;

use App\Models\User;
use Filament\Actions\EditAction;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Filters\SelectFilter;
use Filament\Tables\Table;
use Illuminate\Support\Facades\Auth;

class UsersTable
{
    public static function configure(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('id')->sortable(),
                TextColumn::make('name')
                    ->searchable()
                    ->sortable()
                    ->label('Name'),
                TextColumn::make('email')
                    ->searchable()
                    ->sortable(),
                TextColumn::make('roles.name')->label('Rolle'),
                TextColumn::make('created_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                TextColumn::make('updated_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                SelectFilter::make('roles')->relationship('roles', 'name'),
            ])
            ->recordActions([
                EditAction::make()
                    ->visible(function (User $record) {
                        /** @var User|null $user */
                        $user = Auth::user();
                        if (empty($user) || ! $user->hasRole('super_admin')) {
                            return false;
                        }
                        // deny edit of superadmin user accounts
                        if ($record->hasRole('super_admin')) {
                            return false;
                        } else {
                            return true;
                        }
                    }),
            ])
            ->toolbarActions([

            ]);
    }
}
