<?php

namespace App\Http\Controllers;

use App\Models\Article;
use Barryvdh\DomPDF\Facade\Pdf;
use Illuminate\Http\Request;

class ArticleController extends Controller
{
    /**
     * Create pdf for canyon
     *
     * @return View|Response
     *
     * @throws AuthorizationException
     */
    public function pdf(Request $req)
    {
        $articles = Article::getArticleLables();
        if ($articles->count() > 0) {
            $filename = 'Etiketten.pdf';

            // show debug html view when we get /admin/pdf?html=1
            if ($req->input('html')) {
                return view('pdf.print', ['articles' => $articles]);
            } else {
                return Pdf::loadView('pdf.print', ['articles' => $articles])->stream($filename);
            }
        } else {
            abort(404);
        }
    }
}
