<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;

class RedirectPagesOnAuthentication
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        // for logged in users a few urls need to be redirected
        if (Auth::check()) {

            if ($request->routeIs('filament.guest.pages.home')) {
                return redirect('/admin/home');
            }
            if ($request->routeIs('filament.guest.pages.market')) {
                return redirect('/admin/market');
            }

            if ($request->routeIs('filament.guest.pages.prerecording')) {
                return redirect('/admin/prerecording');
            }
        }

        return $next($request);
    }
}
