<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

/**
 * This model is used to view all articles from the admin page, update, delete etc is forbidden but no limits on viewing data
 */
class AllArticle extends Model
{
    protected $table = 'articles'; // we will reuse the same table as the article model here

    protected static function booted()
    {
        // Block Creation and Updates
        static::saving(function ($model) {
            return false; // Returning false cancels the Eloquent action
        });

        // Block Deletions
        static::deleting(function ($model) {
            return false;
        });
    }

    public function articleGroup(): BelongsTo
    {
        return $this->belongsTo(ArticleGroup::class);
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }
}
