<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use OwenIt\Auditing\Contracts\Auditable;

class ArticleGroup extends Model implements Auditable
{
    use \OwenIt\Auditing\Auditable;

    // elements possible to set on update or create
    protected $fillable = [
        'price_limit',
    ];

    public function articles(): HasMany
    {
        return $this->hasMany(Article::class);
    }
}
