<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Storage;
use OwenIt\Auditing\Contracts\Auditable;

class File extends Model implements Auditable
{
    use \OwenIt\Auditing\Auditable;

    protected $auditInclude = [
        'name', 'file',
    ];

    // elements possible to set on update or create
    protected $fillable = [
        'name', 'file',
    ];

    protected static function booted(): void
    {
        // when deleting model also delete file
        static::deleting(function ($model) {
            if (Storage::disk('public')->exists($model->file)) {
                Storage::disk('public')->delete($model->file);
            }
        });
    }

    //
}
