<?php

declare(strict_types=1);

namespace App\Policies;

use Illuminate\Foundation\Auth\User as AuthUser;
use App\Models\AllArticle;
use Illuminate\Auth\Access\HandlesAuthorization;

class AllArticlePolicy
{
    use HandlesAuthorization;
    
    public function viewAny(AuthUser $authUser): bool
    {
        return $authUser->can('ViewAny:AllArticle');
    }

    public function view(AuthUser $authUser, AllArticle $allArticle): bool
    {
        return $authUser->can('View:AllArticle');
    }

    public function create(AuthUser $authUser): bool
    {
        return $authUser->can('Create:AllArticle');
    }

    public function update(AuthUser $authUser, AllArticle $allArticle): bool
    {
        return $authUser->can('Update:AllArticle');
    }

    public function delete(AuthUser $authUser, AllArticle $allArticle): bool
    {
        return $authUser->can('Delete:AllArticle');
    }

    public function restore(AuthUser $authUser, AllArticle $allArticle): bool
    {
        return $authUser->can('Restore:AllArticle');
    }

    public function forceDelete(AuthUser $authUser, AllArticle $allArticle): bool
    {
        return $authUser->can('ForceDelete:AllArticle');
    }

    public function forceDeleteAny(AuthUser $authUser): bool
    {
        return $authUser->can('ForceDeleteAny:AllArticle');
    }

    public function restoreAny(AuthUser $authUser): bool
    {
        return $authUser->can('RestoreAny:AllArticle');
    }

    public function replicate(AuthUser $authUser, AllArticle $allArticle): bool
    {
        return $authUser->can('Replicate:AllArticle');
    }

    public function reorder(AuthUser $authUser): bool
    {
        return $authUser->can('Reorder:AllArticle');
    }

}