<?php

declare(strict_types=1);

namespace App\Policies;

use Illuminate\Foundation\Auth\User as AuthUser;
use App\Models\ArticleGroup;
use Illuminate\Auth\Access\HandlesAuthorization;

class ArticleGroupPolicy
{
    use HandlesAuthorization;
    
    public function viewAny(AuthUser $authUser): bool
    {
        return $authUser->can('ViewAny:ArticleGroup');
    }

    public function view(AuthUser $authUser, ArticleGroup $articleGroup): bool
    {
        return $authUser->can('View:ArticleGroup');
    }

    public function create(AuthUser $authUser): bool
    {
        return $authUser->can('Create:ArticleGroup');
    }

    public function update(AuthUser $authUser, ArticleGroup $articleGroup): bool
    {
        return $authUser->can('Update:ArticleGroup');
    }

    public function delete(AuthUser $authUser, ArticleGroup $articleGroup): bool
    {
        return $authUser->can('Delete:ArticleGroup');
    }

    public function restore(AuthUser $authUser, ArticleGroup $articleGroup): bool
    {
        return $authUser->can('Restore:ArticleGroup');
    }

    public function forceDelete(AuthUser $authUser, ArticleGroup $articleGroup): bool
    {
        return $authUser->can('ForceDelete:ArticleGroup');
    }

    public function forceDeleteAny(AuthUser $authUser): bool
    {
        return $authUser->can('ForceDeleteAny:ArticleGroup');
    }

    public function restoreAny(AuthUser $authUser): bool
    {
        return $authUser->can('RestoreAny:ArticleGroup');
    }

    public function replicate(AuthUser $authUser, ArticleGroup $articleGroup): bool
    {
        return $authUser->can('Replicate:ArticleGroup');
    }

    public function reorder(AuthUser $authUser): bool
    {
        return $authUser->can('Reorder:ArticleGroup');
    }

}