<?php

declare(strict_types=1);

namespace App\Policies;

use Illuminate\Foundation\Auth\User as AuthUser;
use App\Models\TmkArticle;
use Illuminate\Auth\Access\HandlesAuthorization;

class TmkArticlePolicy
{
    use HandlesAuthorization;
    
    public function viewAny(AuthUser $authUser): bool
    {
        return $authUser->can('ViewAny:TmkArticle');
    }

    public function view(AuthUser $authUser, TmkArticle $tmkArticle): bool
    {
        return $authUser->can('View:TmkArticle');
    }

    public function create(AuthUser $authUser): bool
    {
        return $authUser->can('Create:TmkArticle');
    }

    public function update(AuthUser $authUser, TmkArticle $tmkArticle): bool
    {
        return $authUser->can('Update:TmkArticle');
    }

    public function delete(AuthUser $authUser, TmkArticle $tmkArticle): bool
    {
        return $authUser->can('Delete:TmkArticle');
    }

    public function restore(AuthUser $authUser, TmkArticle $tmkArticle): bool
    {
        return $authUser->can('Restore:TmkArticle');
    }

    public function forceDelete(AuthUser $authUser, TmkArticle $tmkArticle): bool
    {
        return $authUser->can('ForceDelete:TmkArticle');
    }

    public function forceDeleteAny(AuthUser $authUser): bool
    {
        return $authUser->can('ForceDeleteAny:TmkArticle');
    }

    public function restoreAny(AuthUser $authUser): bool
    {
        return $authUser->can('RestoreAny:TmkArticle');
    }

    public function replicate(AuthUser $authUser, TmkArticle $tmkArticle): bool
    {
        return $authUser->can('Replicate:TmkArticle');
    }

    public function reorder(AuthUser $authUser): bool
    {
        return $authUser->can('Reorder:TmkArticle');
    }

}