<?php

namespace App\Providers\Filament;

use App\Filament\Pages\Auth\CustomLogout;
use App\Http\Middleware\RedirectPagesOnAuthentication;
use Filament\Http\Middleware\Authenticate;
use Filament\Http\Middleware\AuthenticateSession;
use Filament\Http\Middleware\DisableBladeIconComponents;
use Filament\Http\Middleware\DispatchServingFilamentEvent;
use Filament\Navigation\NavigationItem;
use Filament\Panel;
use Filament\PanelProvider;
use Filament\Support\Colors\Color;
use Filament\View\PanelsRenderHook;
use Illuminate\Auth\Middleware\RedirectIfAuthenticated;
use Illuminate\Contracts\View\View;
use Illuminate\Cookie\Middleware\AddQueuedCookiesToResponse;
use Illuminate\Cookie\Middleware\EncryptCookies;
use Illuminate\Foundation\Http\Middleware\VerifyCsrfToken;
use Illuminate\Routing\Middleware\SubstituteBindings;
use Illuminate\Session\Middleware\StartSession;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Blade;
use Illuminate\View\Middleware\ShareErrorsFromSession;

class GuestPanelProvider extends PanelProvider
{
    public function panel(Panel $panel): Panel
    {
        return $panel
            ->id('guest')
            ->path('')
            ->viteTheme('resources/css/filament/guest/theme.css')
            ->default()
            ->colors([
                'primary' => Color::Blue,
            ])
            ->navigationItems([
                NavigationItem::make('Login') // logout button is defined as workaround, see app/Filament/Pages/Auth/Logout.php
                    ->url('/admin/login')
                    ->hidden(fn () => Auth::check())
                    ->sort(90)
                    ->icon('heroicon-o-lock-closed'),
            ])
            ->navigationGroups([
                'Admin',        // First
                'Super Admin',        // Second
            ])
            ->globalSearch(false) // replace global search by text below
            ->renderHook(
                'panels::global-search.before',
                fn (): View => view('filament.custom-mobile-logo'),
            )
            ->renderHook(
                PanelsRenderHook::HEAD_END,
                fn (): string => Blade::render('<link rel="sitemap" type="application/xml" title="Sitemap" href="/sitemap.xml">'),
            )
            ->darkMode(false) // Disables dark mode and removes the toggle
            ->discoverResources(in: app_path('Filament/Guest/Resources'), for: 'App\Filament\Guest\Resources')
            ->discoverPages(in: app_path('Filament/Guest/Pages'), for: 'App\Filament\Guest\Pages')
            ->pages([
                CustomLogout::class,
            ])
            ->discoverWidgets(in: app_path('Filament/Guest/Widgets'), for: 'App\Filament\Guest\Widgets')
            ->widgets([
            ])
            ->middleware([
                EncryptCookies::class,
                AddQueuedCookiesToResponse::class,
                StartSession::class,
                AuthenticateSession::class,
                ShareErrorsFromSession::class,
                VerifyCsrfToken::class,
                SubstituteBindings::class,
                DisableBladeIconComponents::class,
                DispatchServingFilamentEvent::class,
                RedirectPagesOnAuthentication::class,
            ])
            ->authMiddleware([
                // Authenticate::class, //guest panel can be accessed without authentication
                // RedirectIfAuthenticated::class, // redirect when user is authenticated, config see bootstrap/app.php
            ]);
    }
}
