<?php

namespace App\Rules;

use App\Models\ArticleGroup;
use Closure;
use Illuminate\Contracts\Validation\ValidationRule;

class ArticlePriceValidation implements ValidationRule
{
    public function __construct(protected ?int $articleGroupId) {}

    /**
     * Run the validation rule.
     *
     * @param  \Closure(string, ?string=): \Illuminate\Translation\PotentiallyTranslatedString  $fail
     */
    public function validate(string $attribute, mixed $value, Closure $fail): void
    {
        if (! empty($this->articleGroupId)) {

            // check if we are above 100 and we have comma values
            if (floor(floatval($value)) != floatval($value) && floatval($value) > 100) {
                $fail('Bitte für Preise über 100€ keine Kommawerte eingeben');
            }

            // check for max price of article-group
            $group = ArticleGroup::where('id', $this->articleGroupId)->first();

            if (empty($group?->price_limit)) {
                $limit = 99999;
                $msg = 'Maximalpreis von 99999 erlaubt';
            } else {
                $limit = intval($group->price_limit);
                $msg = 'Für Artikelgruppe '.$group->name.' sind maximal '.intval($group->price_limit).'€ erlaubt';
            }

            if (floatval($value) > $limit) {
                $fail($msg);
            }
        }
    }
}
