<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('articles', function (Blueprint $table) {
            $table->id()->from(30001); // start autoincrement from 30.000, that articles between recording and pre-recording are not clashing
            $table->integer('user_id')->index();
            $table->string('ean', 13)->nullable(); // will be auto generated after the article is created
            $table->string('name');
            $table->float('price');
            $table->integer('article_group_id')->nullable();
            $table->string('size', 10)->nullable();
            $table->string('brand', 50)->nullable();
            $table->integer('imported_year')->nullable(); // needed on imports to create the old eans for a specific year
            $table->integer('lables_needed')->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('articles');
    }
};
