<?php

namespace Database\Seeders;

use App\Models\ArticleGroup;
use Carbon\Carbon;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class ArticleGroupSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $mapping_matching_tauschmarkt_db = [
            '1' => 'Dirndlkleid',
            '2' => 'Trachtenkleid',
            '3' => 'Lederhose',
            '4' => 'Blazer',
            '5' => 'Anzug',
            '6' => 'Kostüm',
            '7' => 'Bluse',
            '8' => 'Hemd',
            '9' => 'Instrument',
            '10' => 'Notenmaterial',
            '12' => 'Sakko',
            '14' => 'Schallplatte',
            '15' => 'Kindertrachten',
            '16' => 'Schuhe',
            '17' => 'Accesoires',
            '18' => 'Rock',
            '19' => 'Schürze',
            '20' => 'Hut',
            '21' => 'Gilet',
            '22' => 'Mantel',
            '23' => 'Strickjacke',
            '51' => 'T-Shirt', // newly added
            '52' => 'Jacke', // newly added
        ];

        foreach ($mapping_matching_tauschmarkt_db as $id => $name) {
            $group = ArticleGroup::where('id', $id)->first();
            if (empty($group)) {
                DB::table('article_groups')->insert([
                    'id' => $id,
                    'name' => $name,
                    'created_at' => Carbon::now(),
                    'updated_at' => Carbon::now(),
                ]);
            } else {
                $group->name = $name;
                $group->timestamps = false;
                $group->save();
            }
        }
    }
}
