<?php

namespace Database\Seeders;

use App\Models\Article;
use App\Models\ArticleGroup;
use Carbon\Carbon;
use Illuminate\Database\Seeder;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\DB;

class ArticleSeeder2025 extends Seeder
{
    /**
     * We try to import once the data for user TMK from year 2025, only article that are not marked as sold are in the import
     *
     * Start manually with php artisan db:seed --class=ArticleSeeder2025
     */
    public function run(): void
    {
        $file = file_get_contents(storage_path('imports/tauschmarkt_2025_tmk_export.csv'));
        $tmk_user_id = config('app.user_id_tmk_koppl');
        $counter = 0;

        $rows = explode("\n", $file);
        foreach ($rows as $row) {
            $items = explode('|', $row);
            $nr = intval(Arr::get($items, 0));
            $name = trim(Arr::get($items, 1));
            $price = floatval(Arr::get($items, 2));
            $size = trim(Arr::get($items, 4));
            $ref_article_group = intval(Arr::get($items, 5));
            $articleGroup = ArticleGroup::where('id', $ref_article_group)->first();
            $brand = trim(Arr::get($items, 6));
            $year = 2025;
            $ean = Article::calculateEan($nr, $year);

            // looks valid .. import it
            if (intval($nr) > 800 && intval($nr) < 30000 && strlen($name) > 3 && $price > 1) {
                $found = Article::find($nr);
                if (empty($found)) {
                    // create new article with id usind db insert
                    DB::table('articles')->insert([
                        'id' => $nr,
                        'user_id' => $tmk_user_id,
                        'ean' => $ean,
                        'name' => $name,
                        'price' => $price,
                        'article_group_id' => $articleGroup->id ?? null,
                        'size' => empty($size) ? null : $size,
                        'brand' => empty($brand) ? null : $brand,
                        'imported_year' => $year,
                        'created_at' => Carbon::now(),
                        'updated_at' => Carbon::now(),
                    ]);
                    $counter++;
                }
            }
        }

        $this->command->info($counter.' articles have been imported.');
    }
}
