<?php

namespace Database\Seeders;

use App\Models\Post;
use Illuminate\Database\Seeder;

class PostSeeder extends Seeder
{
    /**
     * Create all post slugs with init text in order to not have users updating slugs manually
     */
    public function run(): void
    {
        $posts = [
            'home' => 'Startseite',
            'market' => 'Info Tauschmarkt',
            'prerecording' => 'Anleitung Vorerfassung',
            'contact_legal' => 'Kontakt / Rechtliches',
            'checklist_techsetup' => 'Checkliste Technik',
            'checklist_marketing' => 'Checkliste Werbung',
            'checklist_kitchen' => 'Checkliste Küche',
            'checklist_todo' => 'Checkliste Todo',
        ];

        foreach ($posts as $slug => $title) {
            $post = Post::where('slug', $slug)->first();
            if (empty($post)) {
                Post::create([
                    'title' => $title,
                    'slug' => $slug,
                    'content' => '{"type":"doc","content":[{"type":"paragraph","content":[{"type":"text","text":"..."}],"attrs":{"textAlign":"start"}}]}',
                ]);
            }
        }

    }
}
