<?php

namespace Database\Seeders;

use App\Models\Setting;
use Illuminate\Database\Seeder;

class SettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $settings = [
            'help_text_price' => [
                'value' => 'TODO: hier soll eine Preisempfehlunginfo stehen als Kurztext',
                'description' => 'Hinweistext welcher bei Artikelerfassung zum Preis angegeben wird. Enthält z.B. Preisvorschläge und übliche Preis-Ranges.',
                'type' => 'string',
            ],
            'help_text_labels_needed' => [
                'value' => 'TODO: hier soll eine Etiketteninfo stehen als Kurztext',
                'description' => 'Hinweistext welcher erklärt wozu man mehr als ein Etikett benötigt',
                'type' => 'string',
            ],
            'pre_recording_start_ts' => [
                'value' => '11.01.2026 20:27:48',
                'description' => 'Zeitpunkt ab wann eine Vorerfassung starten darf',
                'type' => 'datetime',
            ],
            'pre_recording_end_ts' => [
                'value' => '11.01.2026 20:27:48',
                'description' => 'Zeitpunkt ab wann eine Vorerfassung nicht mehr möglich ist',
                'type' => 'datetime',
            ],
            'max_articles_per_customer' => [
                'value' => '35',
                'description' => 'Maximalanzahl von Artikeln welche ein Kunde erfassen kann',
                'type' => 'number',
            ],
            'max_articles_total' => [
                'value' => '2000',
                'description' => 'Maximalanzahl von Artikeln welche Kunden (ohne TMK) in der Vorerfassung erfassen können',
                'type' => 'number',
            ],
        ];

        foreach ($settings as $key => $array) {
            $setting = Setting::where('key', $key)->first();
            if (empty($setting)) {
                Setting::create([
                    'key' => $key,
                    'value' => $array['value'],
                    'description' => $array['description'],
                    'type' => $array['type'],
                ]);
            }
        }
    }
}
