<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

class UserRoleSeeder extends Seeder
{
    /**
     * always create main user roles if they dont exist
     *
     * @var string[]
     */
    public static array $roles = [
        'user',
        'admin',
        'super_admin',
    ];

    /**
     * Run the database seeder
     * php artisan db:seed --class=UserRoleSeeder
     *
     * @return void
     */
    public function run()
    {
        // create all roles
        foreach (self::$roles as $role) {
            $roleExists = Role::where('name', $role)->exists();
            if (empty($roleExists)) {
                Role::create(['name' => $role]);
            }
        }

        // create a TMK dummy user with hardcoded user id from app config
        $user_id = config('app.user_id_tmk_koppl');
        if (empty(User::find($user_id))) {
            DB::table('users')->insert([
                'id' => $user_id,
                'name' => 'TMK-Koppl',
                'email' => 'webmaster@tauschmarkt-koppl.at',
                'password' => Hash::make(Str::password(30)),
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }

        // add all permissions to super admin
        $role = Role::findByName('super_admin');
        $role->syncPermissions(Permission::all());

        // clear permission cache
        app()->make(\Spatie\Permission\PermissionRegistrar::class)->forgetCachedPermissions();

        // show hint
        $this->command->info('');
        $this->command->info('  HINT: In order to make a user super_admin use cmd command: php artisan shield:super-admin');
        $this->command->info('');

    }
}
