@props(['article'])

{{-- We use a table because dompdf does not support Flexbox/Gap --}}
<table
    style="width: 100%; border: 0.5pt dashed #9ca3af; border-collapse: collapse; font-family: Arial, sans-serif; table-layout: fixed;">
    <tbody>
        <tr>
            <td colspan="4" style="font-size: 9px; padding-left: 18px; color: #6b7280; padding-top: 4px;">
                Tauschmarkt TMK-Koppl {{ date('Y') }} Vorerfassung - Teil
                {{ $article->tmp_label_counter }}/{{ $article->lables_needed }}
            </td>
        </tr>

        <tr>
            @if (strlen($article->name) > 20)
                {{-- two line text --}}
                <td colspan="4"
                    style="text-align: left; font-size: 12px; font-weight: bold; padding-top: 2px; padding-left: 18px; height: 18px; vertical-align: top;">
                    {{ Str::limit($article->name, 60) }}
                </td>
            @else
                <td colspan="4"
                    style="text-align: left; font-size: 15px; font-weight: bold; padding-top: 2px; padding-left: 18px; height: 20px; vertical-align: top;">
                    {{ Str::limit($article->name, 20) }}
                </td>
            @endif
        </tr>

        <tr>
            <td style="font-size: 9px; color: #6b7280; padding-left: 18px;">Artikel:</td>
            <td style="font-size: 9px; color: #6b7280; padding-left: 12px;">Kunde:</td>
            <td style="font-size: 9px; color: #6b7280; width: 22%;">
                {{ !empty($article->size) ? 'Größe:' : '' }}
            </td>
            <td style="font-size: 9px; color: #6b7280; width: 30%; text-align: right; padding-right: 24px;">Preis:</td>
        </tr>

        <tr>
            <td style="font-size: 18px; font-weight: bold; padding-left: 18px; vertical-align: baseline;">
                {{ str_pad($article->id, 5, '0', STR_PAD_LEFT) }}
            </td>
            <td style="font-size: 14px; vertical-align: baseline; padding-left: 17px;">
                {{ $article->user_id }}
            </td>
            <td style="font-size: 14px; vertical-align: baseline;">
                {{ !empty($article->size) ? Str::limit($article->size, 7, '') : '' }}
            </td>
            <td
                style="font-size: 18px; font-weight: bold; text-align: right; padding-right: 16px; vertical-align: baseline;">
                @if ($article->price > 1000 || floatval(intval($article->price)) === floatval($article->price))
                    {{ number_format($article->price, 0, '', '') }}€
                @else
                    {{ number_format($article->price, 2, ',', '') }}€
                @endif

            </td>
        </tr>

        <tr>
            <td colspan="4" style="text-align: center; padding-left: 10px; padding-bottom: 6px;">
                <div style="display: block;">
                    {!! App\Models\Article::EAN13toPng($article->ean) !!}
                </div>
            </td>
        </tr>
    </tbody>
</table>
