@php
    if (empty($page_slug)) {
        throw new \Exception('ERROR: page_slug is missing from the filamewnt page');
    }
    $post = App\Models\Post::where('slug', $page_slug)->first();
    if (empty($post) || empty($post?->content)) {
        throw new \Exception('ERROR: post for slug ' . $page_slug . ' not found or empty');
    }
@endphp

<x-filament-panels::page>
    <div class="fi-prose">
        {{-- Page content --}}
        {{ \Filament\Forms\Components\RichEditor\RichContentRenderer::make($post->content)->fileAttachmentsDisk('public')->fileAttachmentsVisibility('public') }}
    </div>
</x-filament-panels::page>
